define(['CustomMessagesService'], function () {
	'use strict';

	describe('The Custom Messages Service', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			service,
			mhpuser,
			localResourceDirectory;

		beforeEach(function() {
			module('angularTemplateApp');

			localResourceDirectory = {
				'mhpuser': '/user',
				'var-custom-messages' : '/custom-messages/'
			};

			mhpuser = {
				vistaLocation: '523'
			};

			module(function($provide) {
				$provide.value('mhpuser', mhpuser);
				$provide.value('localResourceDirectoryService', localResourceDirectory);
			});

			inject(function($rootScope, _$httpBackend_, CustomMessagesService) {
				$scope = $rootScope;
				$httpBackend = _$httpBackend_;
				service = CustomMessagesService;
			});
		});


		it('should be able to fetch custom messages', function () {
			$httpBackend.expectGET(localResourceDirectory['var-custom-messages']).respond('200',
				{
					
				}
			);

			service.fetch();
			$scope.$digest();
			$httpBackend.flush();
		});

		it('should be able to save a customMessage', function () {
			var customMessages = {
				"messageId" : 'testMessage',
				"messageText" :'This is a test message',
				link: [{
					href: '/custom-messages/site/523'
				}]
			};

			$httpBackend.expectPUT(localResourceDirectory['var-custom-messages']).respond(function (method, url, data) {
				return [
					200,
					customMessages,
					''
				];
			});

			service.save(customMessages);
			$scope.$digest();
			$httpBackend.flush();
		});
	});
});
